<?php
require_once '../../config/config.php';
require_once '../../config/auth.php';
require_once '../../config/database.php';

require_once '../../templates/header.php';
require_once '../../templates/sidebar.php';

// ambil data anggota
$anggota = $db->query("SELECT id, nama FROM anggota ORDER BY nama ASC");
?>

<h2>Simpanan Sukarela</h2>

<form action="../../process/simpanan_process.php" method="POST">
    <input type="hidden" name="aksi" value="sukarela">

    <div class="form-group">
        <label>Anggota</label>
        <select name="anggota_id" required>
            <option value="">-- Pilih Anggota --</option>
            <?php while ($a = $anggota->fetch_assoc()): ?>
                <option value="<?= $a['id']; ?>">
                    <?= $a['nama']; ?>
                </option>
            <?php endwhile; ?>
        </select>
    </div>

    <div class="form-group">
        <label>Jumlah Simpanan Sukarela</label>
        <input type="number" name="jumlah" required>
    </div>

    <button type="submit" class="btn btn-primary">Simpan</button>
</form>

<?php require_once '../../templates/footer.php'; ?>
<?php
require_once '../../config/database.php';

// Ambil data simpanan sukarela
$query = "
    SELECT s.id, a.no_anggota, a.nama, s.jumlah, s.tanggal
    FROM simpanan s
    JOIN anggota a ON s.anggota_id = a.id
    WHERE s.jenis = 'sukarela'
    ORDER BY s.tanggal DESC
";
$result = $conn->query($query);

// Tentukan view
$content = __DIR__ . '/sukarela_view.php';

// Panggil layout utama
require_once '../../templates/layout.php';
